from matplotlib import pyplot as plt
import numpy as np
import pandas as pd

plt.style.use("fivethirtyeight")

# playing a video game where we have teams
# and we want to track ot the total points for the whole team
# and also how many points each individual player has scored/contributed
# this is the kind o problems specific for stack plots
minutes = [1,2,3,4,5,6,7,8,9]

player1 = [1,2,3,3,4,4,4,4,5]
player2 = [1,1,1,1,2,2,2,3,4]
player3 = [1,1,1,2,2,2,3,3,3]

labels = ["Player 1", "Player 2", "Player 3"]
colors = ["#008fd5", "#fd4f30", "#6d904f"]

# pie chart is excellent for individual timestamps and points at those points
# but for analizing the entire game over a period of time, they are not good 

plt.figure(1)
plt.pie([1,1,1], labels=["Player 1", "Player 2", "Player 3"])
plt.title("My awesome pie plot")
plt.tight_layout()


## pie charts show how something relates to the whole just once
# in the previous example we showed the popularity of programmming
# languages for a specific year

## stack plots do the same, just over time
# they can show us the trend of popularity over many years
# excelent for tracking the total, as well as break down of that total by a specific category
plt.figure(2)
plt.stackplot(minutes, player1, player2, player3, labels=labels,
                colors=colors)
plt.legend(loc="upper left")
plt.title("My awesome stack plot")
plt.tight_layout()

plt.show()